# Oxygen.Q Wartezeiten API

Um Ihren Kunden jederzeit die aktuelle Wartesituation direkt auf Ihrer Webseite anzeigen zu können, bietet Oxygen.Q ein einfaches REST-API an.

## Funktionsprinzip

![Schema](assets/schema.png)

## Voraussetzungen

1. Ihr System muss mit dem Internet verbunden sein.
2. Sie benötigen ein Zugriffstoken für Ihr System. Sollten Ihnen das Token noch nicht übermittelt worden sein, wenden Sie sich bitte an support@doohmedia.net.

## Schnittstellenbeschreibung

### Endpunkt

| **Methode** | **URL** | **Parameter** |
|-----------|-------|-------------|
| GET | https://public.oxygenq.com/statistics | Query-String-Parameter `token` mit dem Zugriffstoken.

Beispiel: `https://public.oxygenq.com/statistics?token=LIiWrwb7IsfhIY51apY4`

Das hier aufgeführte Token zeigt auf ein internes Demosystem und kann für Tests verwendet werden.

### Rückgabe

Die Antwort des Servers erfolgt immer als JSON-Body (Content-Type: `application/json; charset=utf-8`). 

Im Erfolgsfall sieht das zurück gegebene JSON-Objekt folgendermaßen aus:

```
{
    "last_seen_date": "2019-09-06T11:21:54.806Z",
    "queue_stats": [
        {
            "name": "Bürgerbüro",
            "ticket_num_today": 2,
            "ticket_num_open": 1,
            "ticket_num_in_call": 0,
            "median_duration_till_call": 681,
            "median_duration_till_close": 782.5
        },
        {
            "name": "KFZ Meldestelle",
            "ticket_num_today": 11,
            "ticket_num_open": 2,
            "ticket_num_in_call": 1,
            "median_duration_till_call": 595,
            "median_duration_till_close": 996
        }
    ],
    "waiting_area": {
        "queue_limit_enabled": true,
        "queue_limit_max_num": 20,
        "queue_limit_curr_num": 3,
        "is_selfservice_terminal_open": true        
    }
}
```

| Feld | Datentyp | Beschreibung |
|------|----------|--------------|
| last_seen_date | ISO 8601 Zeitstempel | Uhrzeit der letzten Datenübertragung vom System. |
| queue_stats | Array | Array mit der jeweiligen Wartesituation pro Rufzone/Anliegen. Wenn Ihr System keine Rufzonen benutzt, hat dieses Array nur ein einziges Element. |
| queue_stats.name | String | Name der jeweiligen Rufzone. Wenn Ihr Systen keine Rufzonen benutzt, ist dieser Wert `null`. |
| queue_stats.ticket_num_today | Number | Anzahl aller Tickets in dieser Rufzone seit Beginn des Tages (00:00 Uhr). |
| queue_stats.ticket_num_open | Number | Anzahl aller aktuell offenen/wartenden Tickets in dieser Rufzone. |
| queue_stats.ticket_num_in_call | Number | Anzahl aller momentan aufgerufenen Tickets in dieser Rufzone. |
| queue_stats.median_duration_till_call | Number | Mediane Wartezeit bis zum 1. Aufruf in dieser Rufzone. Der Wert wird über alle Tickets der letzten 24h berechnet (d.h. früh morgens bezieht dieser Wert die Wartezeiten der Tickets vom Vortag mit ein).  |    
| queue_stats.median_duration_till_close | Number | Mediane Bearbeitungszeit von Ticketerstellung bis -abschluß in dieser Rufzone. Auch dieser Wert wird über alle Tickets der letzten 24h berechnet.  |
| waiting_area | Object | Aktueller Zustand im Wartebereich. |
| waiting_area.queue_limit_enabled | Boolean | Gibt an, ob die Beschränkung auf eine maximale Anzahl von offenen Tickets im Wartebereich aktiviert ist. Ist dieser Wert `false`, wird das eingestellte Limit in `queue_limit_max_num` ignoriert. |
| waiting_area.queue_limit_max_num | Number | Maximal erlaubte Anzahl gleichzeitig offener Tickets. |
| waiting_area.queue_limit_curr_num | Number | Aktuell offene Tickets. |
| waiting_area.is_selfservice_terminal_open | Boolean | Aktueller Öffnungszustand des Ticketdruck-Terminals. Ist dieser Wert `false` können keine Tickets ausgedruckt werden. Dieser Wert hängt nicht nur von der oben definierten maximalen Ticketanzahl ab, sondern kann auch manuell vom Mitarbeiter gesetzt werden. |
 

#### Fehlerbehandlung

Im Fehlerfall wird ein 4xx/5xx-Header gesetzt und der Rückgabewert enthält ein `error`-Feld mit näheren Informationen:

```
{
    "error": "parameter error"
}
```

## Beispiel

Die unter `examples/index.html` abgelegte Webseite zeigt eine rudimentäre, clientseitige Abfrage der aktuellen Wartesituation mit JavaScript. Da das Token ausschließlich zur Abfrage der obigen Werte verwendet wird, spricht aus Sicherheitsgründen nichts gegen diesen clientseitigen Ansatz.

Eine serverseitiges Abfrage ist natürlich ebenfalls möglich, die Hintergrund-Aktualisierung der Daten obliegt dann der jeweiligen Kundenimplementierung.