<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>vertical-ticker</title>
    <link rel="stylesheet" href="style.css">
    <script src="jquery-3.2.1.min.js"></script>
    <script src="jquery.base64.min.js"></script>
    <script src="ticker.min.js"></script>
    <script>
    
    function getAllUrlParams(url) {

  // get query string from url (optional) or window
  var queryString = url ? url.split('?')[1] : window.location.search.slice(1);

  // we'll store the parameters here
  var obj = {};

  // if query string exists
  if (queryString) {

    // stuff after # is not part of query string, so get rid of it
    queryString = queryString.split('#')[0];

    // split our query string into its component parts
    var arr = queryString.split('&');

    for (var i=0; i<arr.length; i++) {
      // separate the keys and the values
      var a = arr[i].split('=');

      // in case params look like: list[]=thing1&list[]=thing2
      var paramNum = undefined;
      var paramName = a[0].replace(/\[\d*\]/, function(v) {
        paramNum = v.slice(1,-1);
        return '';
      });

      // set parameter value (use 'true' if empty)
      var paramValue = typeof(a[1])==='undefined' ? true : a[1];

      // (optional) keep case consistent
      paramName = paramName.toLowerCase();
      paramValue = paramValue.toLowerCase();

      // if parameter name already exists
      if (obj[paramName]) {
        // convert value to array (if still string)
        if (typeof obj[paramName] === 'string') {
          obj[paramName] = [obj[paramName]];
        }
        // if no array index number specified...
        if (typeof paramNum === 'undefined') {
          // put the value on the end of the array
          obj[paramName].push(paramValue);
        }
        // if array index number specified...
        else {
          // put the value at that index number
          obj[paramName][paramNum] = paramValue;
        }
      }
      // if param name doesn't exist yet, set it
      else {
        obj[paramName] = paramValue;
      }
    }
  }

  return obj;
}

var url = getAllUrlParams().url;
var speed = getAllUrlParams().speed;
var bgcolor = getAllUrlParams().bgcolor;
var bgbild = getAllUrlParams().bgbild;
var colortitle = getAllUrlParams().colortitle;
var sizetitle = getAllUrlParams().sizetitle;
var sans = getAllUrlParams().sans;
var sans_ext = getAllUrlParams().sans_ext;



        $(document).ready(function() {
        
        
            // Da der Ticker die Größe des Browserfensters zur Berechnung der Elementanimationen benutzt, muss er bei
            // jedem Resize neu initialisiert werden. Ein simpler Reload soll hier reichen.
            $(window).on('resize', function() {
                location.reload();
            });



            ticker.init({
                // URL zum RSS-Feed. Der Feed wird vom Ticker automatisch alle 5 Minuten refreshed, ein Reload der Seite
                // ist nicht notwendig.
                url: url,
                // Proxy benutzen, falls das RSS von einem anderen Server kommt und dieser keinen
                // "Access-Control-Allow-Origin"-Header gesetzt hat. Kann auf *.tvlokal.de vermutlich deaktivert werden.
                useproxy: true,
                // Tickergeschwindigkeit in Sekunden pro 100 Pixel.
                speed: speed,

                // Hintergrund des Tickers. Das Bild halt Priorität vor der Farbe, d.h. wenn beides gesetzt ist, wird
                // das Bild angezeigt.
                background: {
                    color: '#'+bgcolor,//"#000",
                    // Pfad zum Hintergrundbild. Das Bild wird unter Beibehaltung des Seitenverhältnis auf die Größe
                    // des Browserfensters skaliert.
                    image: bgbild//"files/demobg.jpg"
                },

                // Schriftart. Der Oxygen-Player zeigt den Ticker mit IE11 an, das Format muss also EOT, WOFF oder
                // TTF sein.
                font: {
                    file: "files/sans/"+sans,
                    format: sans_ext,
                },

                // Styling der Überschrift. Die Werte werden direkt ins CSS der Seite geschrieben, es sind also z.B.
                // auch prozentuale Werte möglich.
                headline: {
                    size: sizetitle+"px",//"80px",
                    color: '#'+colortitle,//"#fff",
                },

                // Styling für den Tickertext.
                text: {
                    size: "60px",
                    color: "#eee",
                    align: "justify",
                },

                // Styling für den Abstandshalter zwischen den Ticker-Elementen. Ist das Feld "text" leer, wird
                // kein Abstandshalter eingeblendet.
                spacer: {
                    size: "48px",
                    color: "#001aab",
                    text: "- - -",
                }
            });
        });
    
        
    </script>
</head>
<body>
<div id="viewport">
</div>
</body>
</html>
